plotDistTimeStack_allgroups <- function(gammas_g, df, df_topics, pars, plot_title, plot_subtitle, abbr,
                                    normalization = 0, width = 3000, height = 1800, res = 200) {

  gammas2 <- gammas_g %>% #[!duplicated(gammas_g),]
    left_join(df, by = c("document" = "id")) %>%
    group_by(date = year(date)) %>%
    mutate(n_groups = length(unique(group))) %>%
    group_by(topic, add = TRUE) %>%
    summarise(share = mean(gamma),group = first(group_f), n_speeches = n(), n_groups = first(n_groups)) #%>%
  
  gammas2$n_speeches[gammas2$topic==30]<-gammas2$n_speeches[gammas2$topic==30]/2 
  gammas2$share[gammas2$topic==30]<-gammas2$share[gammas2$topic==30]*2
  gammas2 <- gammas2 %>%
  
    ungroup() %>%
    group_by(date,group) %>%
    summarise(share = sum(share), n_speeches = first(n_speeches), n_groups = first(n_groups))
  
  gammas2 <- gammas2 %>%
    mutate(normalized = normalization*100 + (1-normalization)*n_speeches)
  
  plot_obj <- ggplot(gammas2, aes(x = date, y = share*normalized)) +
    geom_area(aes(fill = group)) +
    scale_fill_manual(values = c(RColorBrewer::brewer.pal(12, "Paired"),
                                 "#48A9A6",
                                 "#C0C5C1",
                                 "#BBBE64",
                                 "#81F7E5",
                                 "#73BF21",
                                 "#D0021B",
                                 "#CDEDFD",
                                 "#0099CC",
                                 "#FCBA04",
                                 "#586BA4",
                                 "#F6F5AE",
                                 "#EE5622",
                                 "#7678ED"
    )) +
    guides(fill = guide_legend(reverse=FALSE)) +
    theme_light() +
    labs(x = NULL, y = ifelse(normalization, "%", ""),
         title = plot_title,
         subtitle = plot_subtitle,
         fill = "") + 
    xlim(ifelse(normalization, 1998, 1999), ifelse(normalization, 2018, 2017))
  
  print(plot_obj)
  
  if (pars$savePlots == 1) {
    ggsave(filename = paste(pars$prefix,"time_",abbr,"_norm",normalization,"_stack_",
                            pars$nrTopics,".pdf",sep=""),
           plot = plot_obj, width = width/res, height = height/res, dpi = res)
  }
  return(invisible(plot_obj))
}

plotDistTimeStack_group <- function(gammas_g, df, df_topics, pars, group_sel, plot_title, plot_subtitle, abbr,
                              normalization = 0, width = 3000, height = 1800, res = 200) {
  gammas3 <- gammas_g %>%
    filter(group == group_sel) %>%
    left_join(df, by = c("document" = "id")) %>%
    group_by(date = year(date)) %>%
    mutate(share_group = mean(gamma), n_topics = length(unique(topic))) %>%
    group_by(topic, add = TRUE) %>%
    summarise(share = mean(gamma),
              share_group = first(share_group),
              n_topics = first(n_topics),
              n_speeches = n())
  
  gammas3$n_speeches[gammas3$topic==30]<-gammas3$n_speeches[gammas3$topic==30]/2 #for 49 topics
  gammas3$share[gammas3$topic==30]<-gammas3$share[gammas3$topic==30]*2
    
  gammas3 <- gammas3 %>%  
    ungroup()
  
  gammas3$topic <- factor(gammas3$topic,
                          levels = rev(df_topics$topic),
                          labels = rev(df_topics$topic_desc))
  
  if (normalization < 2) {
    gammas3 <- gammas3 %>%
      mutate(normalized = (1-normalization)*n_speeches + normalization*100)
  } else if (normalization == 2) {
    gammas3 <- gammas3 %>%
      mutate(normalized = 100/(share_group*n_topics))
  }
  
  plot_obj <- ggplot(gammas3, aes(x = date, y = share*normalized)) +
    geom_area(aes(fill = topic)) +
    scale_fill_manual(values = c(RColorBrewer::brewer.pal(12, "Paired"),
                                 "#48A9A6",
                                 "#C0C5C1",
                                 "#BBBE64",
                                 "#81F7E5",
                                 "#73BF21",
                                 "#D0021B",
                                 "#CDEDFD",
                                 "#0099CC",
                                 "#FCBA04",
                                 "#586BA4",
                                 "#F6F5AE",
                                 "#EE5622",
                                 "#7678ED"
                                 )) +
    guides(fill = guide_legend(reverse=FALSE)) +
    theme_light() +
    labs(x = NULL, y = ifelse(normalization, "%", ""),
         title = plot_title,
         subtitle = plot_subtitle,
         fill = "") +
    xlim(ifelse(normalization == 0, 1999, 1998), ifelse(normalization == 0, 2017, 2018))
  
  print(plot_obj)
  
  if (pars$savePlots == 1) {
    ggsave(filename = paste(pars$prefix,"time_topics_",abbr,"_norm",normalization,"_stack_",
                            pars$nrTopics,".pdf",sep=""),
           plot = plot_obj, width = width/res, height = height/res, dpi = res)
  }
  return(invisible(plot_obj))
}